#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_ActionItem : BaseTest 
	{

		private Common.ActionItem _testActionItem;
		private string _testMsg = System.DateTime.Now.ToString();
		private Common.VerifyAction _testReturnAction = Common.VerifyAction.Continue;


		[SetUp]
		protected void SetUp() 
		{	
			this.BaseSetUp();
			
			this._testActionItem = new Common.ActionItem(this._testReturnAction, this._testMsg);
		}

		[Test]
		public void Ctor_VA_String_Pass()
		{
			Assert.AreEqual(this._testReturnAction, this._testActionItem.ReturnAction, "ReturnAction");
			Assert.AreEqual(this._testMsg, this._testActionItem.Message, "Message");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_VA_String_Fail()
		{
		}

		[Test]
		public void ReturnAction_Pass()
		{
			Assert.AreEqual(this._testReturnAction, this._testActionItem.ReturnAction);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ReturnAction_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.AreEqual(this._testMsg, this._testActionItem.Message);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

	}

}
#endif

